/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.client.Client;
import noppes.npcs.client.ClientGuiEventHandler;
import noppes.npcs.client.gui.SubGuiEditBankAccess;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiMenuSideButton;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.containers.ContainerNPCBank;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;
import org.lwjgl.input.Mouse;

public class GuiNPCBankChest
extends GuiContainerNPCInterface
implements ISubGuiListener {
    private static final ResourceLocation backTexture = new ResourceLocation("customnpcs", "textures/gui/smallbg.png");
    private static final ResourceLocation tabsTexture = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final ResourceLocation rowTexture = new ResourceLocation("textures/gui/container/creative_inventory/tab_items.png");
    public ContainerNPCBank cont;
    public int row = 0;
    private final int maxRows;
    private int yPos;
    private int ceilPos = -1;
    private int allCost = 0;
    private final int step;
    private final boolean isMany;
    private boolean hoverScroll;
    private boolean isScrolling = false;
    private boolean upgrade;
    private boolean isWait;
    private boolean isOwner;
    private ItemStack stack;
    private int money;

    public GuiNPCBankChest(EntityNPCInterface npc, ContainerNPCBank container) {
        super(npc, (Container)container);
        this.field_146297_k = Minecraft.func_71410_x();
        this.cont = container;
        this.isMany = container.items.func_70302_i_() > 45;
        this.field_146291_p = false;
        this.maxRows = (int)Math.ceil((double)container.items.func_70302_i_() / 9.0);
        this.field_147000_g = 114 + this.cont.height;
        this.step = this.maxRows > 5 ? (int)(73.0f / ((float)this.maxRows - 5.0f)) : 0;
        this.closeOnEsc = true;
        this.resetSlots();
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (this.isWait) {
            return;
        }
        if (button.getID() > 2 && button.getID() < 8) {
            this.close();
            NoppesUtilPlayer.sendData(EnumPlayerPacket.OpenCeilBank, this.cont.bank.id, ((GuiMenuSideButton)button).data);
            return;
        }
        switch (button.getID()) {
            case 0: {
                NoppesUtilPlayer.sendData(this.upgrade ? EnumPlayerPacket.BankUpgrade : EnumPlayerPacket.BankUnlock, this.npc.func_145782_y(), true, 1);
                this.isWait = true;
                break;
            }
            case 1: {
                if (this.ceilPos <= 0) {
                    return;
                }
                --this.ceilPos;
                this.func_73866_w_();
                break;
            }
            case 2: {
                if ((double)this.ceilPos >= Math.floor((double)this.cont.bank.ceilSettings.size() / 5.0)) {
                    return;
                }
                ++this.ceilPos;
                this.func_73866_w_();
                break;
            }
            case 9: {
                if (this.cont.bank == null) {
                    return;
                }
                this.setSubGui(new SubGuiEditBankAccess(0, this.cont.bank));
                break;
            }
            case 10: {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.BankClearCeil, this.npc.func_145782_y());
                this.isWait = true;
                break;
            }
            case 11: {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.BankLock, this.npc.func_145782_y());
                this.isWait = true;
                break;
            }
            case 12: {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.BankRegrade, this.npc.func_145782_y());
                this.isWait = true;
                break;
            }
            case 13: {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.BankResetCeil, this.npc.func_145782_y());
                this.isWait = true;
                break;
            }
            case 14: {
                if (this.allCost <= 0) {
                    return;
                }
                NoppesUtilPlayer.sendData(EnumPlayerPacket.BankUpgrade, this.npc.func_145782_y(), true, this.allCost);
                this.isWait = true;
            }
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface gui) {
        if (gui instanceof SubGuiEditBankAccess) {
            SubGuiEditBankAccess subGui = (SubGuiEditBankAccess)gui;
            boolean isChanged = false;
            if (this.cont.bank.isChanging != subGui.isChanging) {
                this.cont.bank.isChanging = subGui.isChanging;
                isChanged = true;
            }
            if (!this.cont.bank.owner.equals(subGui.owner)) {
                this.cont.bank.owner = subGui.owner;
                isChanged = true;
            }
            if (subGui.names.size() != this.cont.bank.access.size()) {
                this.cont.bank.access.clear();
                this.cont.bank.access.addAll(subGui.names);
                isChanged = true;
            } else {
                for (String name : subGui.names) {
                    if (this.cont.bank.access.contains(name)) continue;
                    this.cont.bank.access.clear();
                    this.cont.bank.access.addAll(subGui.names);
                    isChanged = true;
                    break;
                }
            }
            if (isChanged) {
                NBTTagCompound compound = new NBTTagCompound();
                this.cont.bank.writeToNBT(compound);
                this.isWait = true;
                Client.sendData(EnumPacketServer.BankSave, compound);
                NoppesUtilPlayer.sendData(EnumPlayerPacket.OpenCeilBank, this.cont.bank.id, this.cont.ceil);
            }
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i;
        this.field_146297_k.func_110434_K().func_110577_a(backTexture);
        int u = (this.field_146294_l - this.field_146999_f) / 2 - 8;
        int v = (this.field_146295_m - this.field_147000_g) / 2;
        int h = this.cont.height + 107;
        this.func_73729_b(u, v, 0, 0, 176, h - 4);
        this.func_73729_b(u, v + h - 4, 0, 218, 176, 4);
        int o = this.isMany ? 36 : 20;
        this.func_73729_b(u + 172, v, 176 - o, 0, o, h - 4);
        this.func_73729_b(u + 172, v + h - 4, 176 - o, 218, o, 4);
        this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
        for (int s = 0; s < this.cont.field_75151_b.size(); ++s) {
            Slot slot = this.cont.func_75139_a(s);
            if (slot.field_75223_e <= 0 || slot.field_75221_f <= 0) continue;
            this.func_73729_b(u + 8 + slot.field_75223_e - 1, v + slot.field_75221_f - 1, 0, 0, 18, 18);
        }
        for (i = 0; (double)i < Math.ceil((double)this.cont.items.func_70302_i_() / 9.0) && i < 5; ++i) {
            this.field_146289_q.func_78276_b("" + (1 + i + this.row), u + 13 - this.field_146289_q.func_78256_a("" + (1 + i + this.row)), v + 4 + (i + 1) * 18, CustomNpcs.LableColor.getRGB());
            this.func_73730_a(u + 4, u + 181, v + 17 + (i + 1) * 18, CustomNpcs.LableColor.getRGB());
            if (i != 0) continue;
            this.func_73730_a(u + 4, u + 181, v - 1 + (i + 1) * 18, CustomNpcs.LableColor.getRGB());
        }
        this.func_73728_b(u + 15, v + 14, v + 1 + (i + 1) * 18, CustomNpcs.LableColor.getRGB());
        this.func_73728_b(u + 177, v + 14, v + 1 + (i + 1) * 18, CustomNpcs.LableColor.getRGB());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Bank.CeilSettings cs = this.cont.bank.ceilSettings.get(this.cont.ceil);
        if (this.isOwner && (cs.maxCells > this.cont.items.func_70302_i_() || this.cont.items.func_70302_i_() == 0)) {
            Slot slot = this.cont.func_75139_a(this.cont.items.func_70302_i_());
            if (!this.stack.func_190926_b()) {
                this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
                this.func_73729_b(u + slot.field_75223_e + 53, v + slot.field_75221_f - 23, 0, 0, 18, 18);
                TextComponentTranslation t = new TextComponentTranslation(this.upgrade ? "bank.upg.cost" : "bank.tab.cost", new Object[0]);
                this.field_146289_q.func_78276_b(t.func_150254_d() + ":", u + slot.field_75223_e, v + slot.field_75221_f - (this.money <= 0 ? 18 : 24), CustomNpcs.LableColor.getRGB());
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (this.money > 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(u + slot.field_75223_e - 5), (float)(v + slot.field_75221_f - 17), (float)0.0f);
                this.field_146297_k.func_110434_K().func_110577_a(ClientGuiEventHandler.COIN_NPC);
                float s = 0.064f;
                GlStateManager.func_179152_a((float)s, (float)s, (float)s);
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)2.0f, (float)2.0f, (float)2.0f, (float)1.0f);
                this.func_73729_b(0, 0, 0, 0, 256, 256);
                GlStateManager.func_179121_F();
                String text = Util.instance.getTextReducedNumber(this.money, true, true, false) + CustomNpcs.displayCurrencies;
                this.field_146289_q.func_175065_a(text, (float)(u + slot.field_75223_e + 11), (float)(v + slot.field_75221_f - 12), CustomNpcs.LableColor.getRGB(), false);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        } else {
            TextComponentTranslation text;
            if (this.cont.items.func_70302_i_() == 0) {
                text = new TextComponentTranslation("bank.slots.empty", new Object[0]);
            } else {
                text = new TextComponentTranslation("bank.slots.info", new Object[]{"" + this.cont.items.getCountEmpty(), "" + this.cont.items.func_70302_i_()});
                if (this.player.field_71075_bZ.field_75098_d) {
                    text.func_150257_a((ITextComponent)new TextComponentString("\u00a73 (GM total in ceil: " + this.cont.bank.ceilSettings.get((Object)Integer.valueOf((int)this.cont.ceil)).maxCells + ")"));
                }
            }
            this.field_146289_q.func_78276_b(text.func_150254_d(), u + 8, v + 8 + (i + 1) * 18, CustomNpcs.LableColor.getRGB());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.isMany) {
            this.field_146297_k.func_110434_K().func_110577_a(rowTexture);
            this.func_73729_b(u + 184, v + 17, 174, 17, 14, 86);
            this.func_73729_b(u + 184, v + 103, 174, 125, 14, 4);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        TextComponentTranslation b = new TextComponentTranslation("gui.bank", new Object[]{": "});
        TextComponentTranslation n = new TextComponentTranslation(this.cont.bank.name, new Object[0]);
        n.func_150256_b().func_150227_a(Boolean.valueOf(true));
        b.func_150257_a((ITextComponent)n).func_150257_a((ITextComponent)new TextComponentString("; "));
        b.func_150257_a((ITextComponent)new TextComponentTranslation("gui.ceil", new Object[]{" #\u00a7l" + (this.cont.ceil + 1)}));
        this.field_146289_q.func_78276_b(b.func_150254_d(), 8, 6, CustomNpcs.LableColor.getRGB());
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int v;
        int u;
        if (this.isWait) {
            this.drawWait();
            return;
        }
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        Bank.CeilSettings cs = this.cont.bank.ceilSettings.get(this.cont.ceil);
        this.hoverScroll = false;
        if (this.isMany && this.subgui == null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)2.0f, (float)2.0f, (float)2.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(tabsTexture);
            float currentScroll = this.maxRows > 5 ? (float)this.row / ((float)this.maxRows - 5.0f) : 0.0f;
            int h = (int)(currentScroll * 73.0f);
            u = (this.field_146294_l - this.field_146999_f) / 2 + 177;
            v = (this.field_146295_m - this.field_147000_g) / 2 + 18 + h;
            this.hoverScroll = mouseX >= u && mouseX <= u + 12 && mouseY >= v && mouseY <= v + 15;
            this.func_73729_b(u, v, this.hoverScroll ? 244 : 232, 0, 12, 15);
            GlStateManager.func_179121_F();
            int dWheel = Mouse.getDWheel();
            if (dWheel != 0) {
                this.resetRow(dWheel < 0);
            }
        }
        PlayerData data = CustomNpcs.proxy.getPlayerData((EntityPlayer)this.player);
        Slot slot = this.cont.func_75139_a(this.cont.items.func_70302_i_());
        u = (this.field_146294_l - this.field_146999_f) / 2;
        v = (this.field_146295_m - this.field_147000_g) / 2;
        if (!this.stack.func_190926_b() && this.isOwner) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(u + slot.field_75223_e + 46), (float)(v + slot.field_75221_f - 22), (float)50.0f);
            RenderHelper.func_74520_c();
            this.field_146297_k.func_175599_af().func_180450_b(this.stack, 0, 0);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            this.func_73731_b(this.field_146297_k.field_71466_p, "" + this.stack.func_190916_E(), 16 - this.field_146297_k.field_71466_p.func_78256_a("" + this.stack.func_190916_E()), 9, -1);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
            if (this.isMouseHover(mouseX, mouseY, u + slot.field_75223_e + 46, v + slot.field_75221_f - 22, 18, 18)) {
                ArrayList<String> list = new ArrayList<String>();
                String t = new TextComponentTranslation("bank." + (this.upgrade ? "upg" : "tab") + ".cost.info", new Object[]{"" + cs.startCells, "" + cs.maxCells}).func_150254_d();
                if (!t.contains("<br>")) {
                    list.add(t);
                } else {
                    Collections.addAll(list, t.split("<br>"));
                }
                list.addAll(this.stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
                this.setHoverText(list);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.money > 0 && this.isOwner && this.isMouseHover(mouseX, mouseY, u + slot.field_75223_e - 11, v + slot.field_75221_f - 14, 50, 12)) {
            String hover = new TextComponentTranslation("market.hover.currency.0", new Object[]{Util.instance.getTextReducedNumber(this.money, true, true, false), CustomNpcs.displayCurrencies, Util.instance.getTextReducedNumber(data.game.getMoney(), true, true, false) + CustomNpcs.displayCurrencies}).func_150254_d();
            this.setHoverText(Arrays.asList(hover.split("<br>")));
        }
        this.allCost = 0;
        int max = 0;
        boolean canPayStack = false;
        boolean canPayMoney = false;
        if (this.getButton(0) != null && this.getButton(14) != null) {
            max = cs.maxCells - this.cont.items.func_70302_i_();
            this.allCost = Math.max(max, 0);
            if (this.player.field_71075_bZ.field_75098_d) {
                canPayStack = true;
                canPayMoney = true;
            } else {
                canPayStack = this.stack.func_190926_b();
                if (!canPayStack) {
                    int allSt = Util.instance.inventoryItemCount((EntityPlayer)this.player, this.stack, null, false, false);
                    this.allCost = Math.min(this.allCost, allSt / this.stack.func_190916_E());
                    canPayStack = allSt >= this.stack.func_190916_E();
                }
                boolean bl = canPayMoney = this.money <= 0;
                if (!canPayMoney) {
                    this.allCost = Math.min(this.allCost, (int)data.game.getMoney() / this.money);
                    canPayMoney = data.game.getMoney() >= (long)this.money;
                }
            }
            this.getButton(0).setEnabled(this.player.field_71075_bZ.field_75098_d || max > 0 && canPayStack && canPayMoney);
            this.getButton(0).setIsVisible(this.isOwner);
            this.getButton(14).setEnabled(this.allCost != 0 && this.allCost <= max);
            this.getButton(14).setIsVisible(this.isOwner && this.upgrade && max > 0);
        }
        if (this.getButton(10) != null) {
            this.getButton(10).setEnabled(this.cont.items.func_70302_i_() > 0 && !this.cont.items.func_191420_l());
        }
        if (this.getButton(13) != null) {
            this.getButton(13).setEnabled(this.cont.items.func_70302_i_() > 0 && (!this.cont.items.func_191420_l() || this.cont.items.func_70302_i_() != this.cont.bank.ceilSettings.get((Object)Integer.valueOf((int)this.cont.ceil)).startCells));
        }
        if (CustomNpcs.ShowDescriptions && this.subgui == null) {
            if (this.getButton(0) != null && this.getButton(0).isHovered()) {
                TextComponentTranslation it = new TextComponentTranslation("bank.hover.update." + this.upgrade, new Object[]{"\u00a761", "" + this.cont.items.func_70302_i_(), "" + this.cont.bank.ceilSettings.get((Object)Integer.valueOf((int)this.cont.ceil)).maxCells});
                if (!this.upgrade && this.cont.dataCeil < this.cont.bank.ceilSettings.size()) {
                    it.func_150257_a((ITextComponent)new TextComponentTranslation("bank.hover.update.not.1", new Object[]{"" + (this.cont.dataCeil + 1)}));
                }
                if (!canPayStack) {
                    it.func_150257_a((ITextComponent)new TextComponentTranslation("bank.hover.update.not.0", new Object[0]));
                }
                if (!canPayMoney) {
                    it.func_150257_a((ITextComponent)new TextComponentTranslation("bank.hover.update.not.1", new Object[0]));
                }
                this.setHoverText(it.func_150254_d(), new Object[0]);
            } else if (this.getButton(1) != null && this.getButton(1).isHovered()) {
                this.setHoverText(new TextComponentTranslation("bank.hover.up", new Object[0]).func_150254_d(), new Object[0]);
            } else if (this.getButton(2) != null && this.getButton(2).isHovered()) {
                this.setHoverText(new TextComponentTranslation("bank.hover.down", new Object[0]).func_150254_d(), new Object[0]);
            } else if (this.getButton(9) != null && this.getButton(9).isVisible() && this.getButton(9).isHovered()) {
                this.setHoverText(new TextComponentTranslation("bank.hover.settings", new Object[0]).func_150254_d(), new Object[0]);
            } else if (this.getButton(10) != null && this.getButton(10).isVisible() && this.getButton(10).isHovered()) {
                this.setHoverText(new TextComponentTranslation("bank.hover.clear.slots", new Object[0]).func_150254_d(), new Object[0]);
            } else if (this.getButton(11) != null && this.getButton(11).isVisible() && this.getButton(11).isHovered()) {
                this.setHoverText(new TextComponentTranslation("bank.hover.lock", new Object[0]).func_150254_d(), new Object[0]);
            } else if (this.getButton(12) != null && this.getButton(12).isVisible() && this.getButton(12).isHovered()) {
                this.setHoverText(new TextComponentTranslation("bank.hover.regrade", new Object[0]).func_150254_d(), new Object[0]);
            } else if (this.getButton(13) != null && this.getButton(13).isVisible() && this.getButton(13).isHovered()) {
                this.setHoverText(new TextComponentTranslation("bank.hover.reset", new Object[0]).func_150254_d(), new Object[0]);
            } else if (this.getButton(14) != null && this.getButton(14).isVisible() && this.getButton(14).isHovered()) {
                TextComponentTranslation it = new TextComponentTranslation("bank.hover.update.true", new Object[]{"\u00a76" + this.allCost + '\u00a7' + "7/" + max, "" + this.cont.items.func_70302_i_(), "" + this.cont.bank.ceilSettings.get((Object)Integer.valueOf((int)this.cont.ceil)).maxCells});
                if (!this.upgrade && this.cont.dataCeil < this.cont.bank.ceilSettings.size()) {
                    it.func_150257_a((ITextComponent)new TextComponentTranslation("bank.hover.update.not.1", new Object[]{"" + (this.cont.dataCeil + 1)}));
                }
                if (!canPayStack) {
                    it.func_150257_a((ITextComponent)new TextComponentTranslation("bank.hover.update.not.0", new Object[0]));
                }
                if (!canPayMoney) {
                    it.func_150257_a((ITextComponent)new TextComponentTranslation("bank.hover.update.not.1", new Object[0]));
                }
                this.setHoverText(it.func_150254_d(), new Object[0]);
            } else {
                for (int i = 3; i < 8; ++i) {
                    if (this.getButton(i) == null || !this.getButton(i).isHovered()) continue;
                    this.setHoverText(new TextComponentTranslation("bank.hover.ceil." + ((GuiMenuSideButton)this.getButton((int)i)).active, new Object[]{"" + ((GuiMenuSideButton)this.getButton((int)i)).data}).func_150254_d(), new Object[0]);
                }
            }
        }
        if (this.hasHoverText()) {
            this.drawHoverText(null, new Object[0]);
        } else {
            this.func_191948_b(mouseX, mouseY);
        }
    }

    public void func_146274_d() throws IOException {
        if (this.isScrolling) {
            int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            if (mouseY - this.yPos >= this.step) {
                this.resetRow(true);
                this.yPos = mouseY;
            } else if ((mouseY - this.yPos) * -1 >= this.step) {
                this.resetRow(false);
                this.yPos = mouseY;
            }
        }
        super.func_146274_d();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.resetSlots();
        this.stack = ItemStack.field_190927_a;
        this.money = 0;
        Bank.CeilSettings cs = this.cont.bank.ceilSettings.get(this.cont.ceil);
        this.isOwner = !this.cont.bank.isPublic || this.player.field_71075_bZ.field_75098_d || this.player.func_70005_c_().equals(this.cont.bank.owner);
        boolean bl = this.upgrade = this.cont.items.func_70302_i_() > 0;
        if (this.cont.items.func_70302_i_() == 0 && !cs.openStack.func_190926_b()) {
            this.stack = cs.openStack;
            this.money = cs.openMoney;
            this.upgrade = false;
        } else if (this.cont.items.func_70302_i_() < cs.maxCells && !cs.upgradeStack.func_190926_b()) {
            this.stack = cs.upgradeStack;
            this.money = cs.upgradeMoney;
            this.upgrade = true;
        }
        Slot slot = this.cont.func_75139_a(this.cont.items.func_70302_i_());
        int u = (this.field_146294_l - this.field_146999_f) / 2 - 8;
        int v = (this.field_146295_m - this.field_147000_g) / 2;
        if (!this.stack.func_190926_b() || this.player.field_71075_bZ.field_75098_d) {
            int x = u + slot.field_75223_e + 80 + (this.stack.func_190926_b() ? 104 + (this.isMany ? 8 : 0) : 0);
            int y = this.stack.func_190926_b() ? this.field_147009_r + 36 : v + slot.field_75221_f - 23;
            GuiNpcButton button = new GuiNpcButton(0, x, y, 50, 18, this.upgrade ? "bank.upgrade" : "bank.unlock");
            button.field_146124_l = this.player.field_71075_bZ.field_75098_d ? !this.upgrade || this.cont.items.func_70302_i_() < cs.maxCells : this.cont.dataCeil == this.cont.bank.ceilSettings.size();
            this.addButton(button);
            button = new GuiNpcButton(14, x + 52, y, 25, 18, "gui.max");
            button.field_146124_l = this.getButton(0).isEnabled();
            button.field_146125_m = cs.maxCells - this.cont.items.func_70302_i_() > 0;
            this.addButton(button);
            if (this.player.field_71075_bZ.field_75098_d) {
                x = u + slot.field_75223_e + 184 + (this.isMany ? 8 : 0);
                y = this.field_147009_r + 14;
                button = new GuiNpcButton(11, x, y, 50, 18, "bank.lock");
                button.field_146124_l = this.cont.items.func_70302_i_() > 0 && !cs.openStack.func_190926_b();
                this.addButton(button);
                button = new GuiNpcButton(12, x, y += this.stack.func_190926_b() ? 44 : 22, 50, 18, "bank.regrade");
                button.field_146124_l = this.cont.items.func_70302_i_() > 0;
                this.addButton(button);
                button = new GuiNpcButton(13, x, y + 22, 50, 18, "gui.reset");
                button.field_146124_l = this.cont.items.func_70302_i_() > 0 && (!this.cont.items.func_191420_l() || this.cont.items.func_70302_i_() != cs.startCells);
                this.addButton(button);
            }
        }
        if (this.ceilPos < 0) {
            this.ceilPos = (int)Math.floor((double)this.cont.ceil / 5.0);
        }
        if (this.cont.bank.ceilSettings.size() > 1) {
            if (this.cont.bank.ceilSettings.size() > 5) {
                if (this.ceilPos > 0) {
                    GuiMenuSideButton tab = new GuiMenuSideButton(1, this.field_147003_i - 8, this.field_147009_r + 4, "\u02c4");
                    tab.field_146121_g = 12;
                    tab.offsetText = 1;
                    this.addButton(tab);
                }
                if ((double)this.ceilPos < Math.floor((double)this.cont.bank.ceilSettings.size() / 5.0)) {
                    GuiMenuSideButton tab = new GuiMenuSideButton(2, this.field_147003_i - 8, this.field_147009_r + 84, "\u02c5");
                    tab.field_146121_g = 12;
                    tab.offsetText = 2;
                    this.addButton(tab);
                }
            }
            for (int i = 0; i < 5 && i + this.ceilPos * 5 < this.cont.bank.ceilSettings.size(); ++i) {
                GuiMenuSideButton tab = new GuiMenuSideButton(3 + i, this.field_147003_i - 8, this.field_147009_r + 20 + i * 12, "" + (1 + i + this.ceilPos * 5));
                tab.data = i + this.ceilPos * 5;
                tab.field_146121_g = 12;
                if (i + this.ceilPos * 5 == this.cont.ceil) {
                    tab.active = true;
                }
                this.addButton(tab);
            }
        }
        if (this.cont.bank.isPublic && (!this.cont.bank.owner.isEmpty() || this.player.field_71075_bZ.field_75098_d)) {
            this.addButton(new GuiNpcButton(9, (this.isMany ? 12 : -4) + (this.field_146294_l + this.field_146999_f) / 2, this.field_147009_r - 8, 20, 20, 20, 146, GuiNPCInterface.WIDGETS));
            this.getButton(9).setIsVisible(this.isOwner);
        }
        GuiNpcButton button = new GuiNpcButton(10, u + slot.field_75223_e + (this.isMany ? 166 : 159), v + slot.field_75221_f - 24, 20, 20, "");
        button.texture = GuiNPCInterface.MENU_BUTTON;
        button.hasDefBack = false;
        button.txrX = 236;
        button.txrW = 20;
        button.txrH = 20;
        button.field_146125_m = this.isOwner;
        this.addButton(button);
        if (this.row > this.maxRows) {
            this.row = this.maxRows;
        }
    }

    @Override
    public void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 200 || keyCode == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i()) {
            this.resetRow(false);
        }
        if (keyCode == 208 || keyCode == this.field_146297_k.field_71474_y.field_74368_y.func_151463_i()) {
            this.resetRow(true);
        }
        super.func_73869_a(typedChar, keyCode);
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.hoverScroll) {
            this.yPos = mouseY;
            this.isScrolling = true;
        } else if (this.isMany) {
            int u = 173 + (this.field_146294_l - this.field_146999_f) / 2;
            int v = 18 + (this.field_146295_m - this.field_147000_g) / 2;
            if (mouseX >= u && mouseX <= u + 11 && mouseY >= v && mouseY <= v + 88) {
                int h = mouseY - v;
                int r = h <= 7 ? 0 : (h >= 81 ? this.maxRows : (int)((double)this.maxRows * (double)h / 88.0));
                int old = this.row;
                if (r < 0) {
                    r = 0;
                }
                if (r > this.maxRows) {
                    r = this.maxRows;
                }
                if (old != r) {
                    this.row = r;
                    this.resetSlots();
                }
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.isScrolling) {
            this.isScrolling = false;
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    private void resetRow(boolean bo) {
        if (!this.isMany) {
            return;
        }
        int old = this.row++;
        if (!bo) {
            --this.row;
        }
        if (this.row < 0) {
            this.row = 0;
        }
        if (this.row > this.maxRows - 5) {
            this.row = this.maxRows - 5;
        }
        if (old != this.row) {
            this.resetSlots();
        }
    }

    private void resetSlots() {
        if (!this.isMany) {
            return;
        }
        int m = this.row * 9;
        int n = m + 45;
        int i = -1;
        int t = this.cont.items.func_70302_i_();
        int u = 0;
        int e = t;
        if (t % 9 != 0) {
            e -= t % 9;
        }
        for (int s = 0; s < t; ++s) {
            Slot slot = this.cont.func_75139_a(s);
            if (s < m || s >= n) {
                slot.field_75223_e = -5000;
                slot.field_75221_f = -5000;
                continue;
            }
            ++i;
            if (s >= e) {
                u = (int)((9.0 - (double)t % 9.0) / 2.0 * 18.0);
            }
            slot.field_75223_e = 8 + u + i % 9 * 18;
            slot.field_75221_f = 18 + i / 9 * 18;
        }
    }
}

